<?php
declare(strict_types=1);

function auth_user(): ?array {
  $uid = $_SESSION['uid'] ?? null;
  if (!$uid) return null;

  $pdo = $GLOBALS['pdo'];
  $st = $pdo->prepare("SELECT id, company_id, name, email, role, is_active FROM users WHERE id=? LIMIT 1");
  $st->execute([(int)$uid]);
  $u = $st->fetch();
  if (!$u || (int)$u['is_active'] !== 1) return null;
  return $u;
}

function require_auth(): array {
  $u = auth_user();
  if (!$u) redirect(base_path('/login'));
  return $u;
}

function auth_login(int $userId): void {
  session_regenerate_id(true);
  $_SESSION['uid'] = $userId;
}

function auth_logout(): void {
  unset($_SESSION['uid']);
}
